-- name: add-sanitise-whitespace-function
--- Will remove any double spaces, and spaces at start and end.
CREATE OR REPLACE FUNCTION sanitise_whitespace(text_to_sanitise text)
  RETURNS text AS
$BODY$
DECLARE
  result text;
BEGIN
  result = REGEXP_REPLACE(trim(text_to_sanitise), '[[:space:]]{2,}', ' ', 'g');
  IF CHAR_LENGTH(result) > 0 THEN
    RETURN result;
  ELSE
    RETURN NULL;
  END IF;
END;
$BODY$
LANGUAGE 'plpgsql' IMMUTABLE;

-- name: add-remove-whitespace-function
--- Removes all whitespace from the text.
CREATE OR REPLACE FUNCTION remove_whitespace(text_to_sanitise text)
  RETURNS text AS
$BODY$
DECLARE
  result text;
BEGIN
  result = REGEXP_REPLACE(trim(text_to_sanitise), '[[:space:]]{1,}', '', 'g');
  IF CHAR_LENGTH(result) > 0 THEN
    RETURN result;
  ELSE
    RETURN NULL;
  END IF;
END;
$BODY$
LANGUAGE 'plpgsql' IMMUTABLE;

-- name: add-trim-whitespace-function
--
-- Removes the whitespace from the ends of the text and makes sure
-- there's only single whitespaces between words.
CREATE OR REPLACE FUNCTION trim_whitespace(text_to_sanitise text)
  RETURNS text AS
$BODY$
DECLARE
  result text;
BEGIN
  result = REGEXP_REPLACE(text_to_sanitise, '^[[:space:]]+|[[:space:]]+$', '', 'g');
  IF CHAR_LENGTH(result) > 0 THEN
    RETURN result;
  ELSE
    RETURN NULL;
  END IF;
END;
$BODY$
LANGUAGE 'plpgsql' IMMUTABLE;
